﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class frmPersonnel : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // check if security level is A
        if (Session["SecurityLevel"] == "A")
        {
            btnSubmit.Visible = true;
            // make the submit button visible
        }
        else
        {
            btnSubmit.Visible = false;
        }
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        string Msg = string.Empty;
        bool validatedState = true;

        string FirstName = Request["txtFirstName"].ToString();
        string LastName = Request["txtLastName"].ToString();
        string strPayRate = Request["txtPayRate"].ToString();
        string strStartDate = Request["txtStartDate"].ToString();
        string strEndDate = Request["txtEndDate"].ToString();

        // validate First Name
        if (FirstName.Trim() == "")
        {
            txtFirstName.BackColor = System.Drawing.Color.Yellow;
            validatedState = false;
            Msg += "Please enter first name. "; 
        }
        // validate Last Name
        else if (LastName.Trim() == "")
        {
            txtFirstName.BackColor = System.Drawing.Color.White;
            txtLastName.BackColor = System.Drawing.Color.Yellow;
            validatedState = false;
            Msg += "Please enter last name. ";
        }
        // validate Pay Rate
        else if (strPayRate.Trim() == "")
        {
            txtLastName.BackColor = System.Drawing.Color.White;
            txtPayRate.BackColor = System.Drawing.Color.Yellow;
            validatedState = false;
            Msg += "Please enter pay rate. ";
        }
        // validate dates for empty field
        else if (strStartDate.Trim() == "")
        {
            txtPayRate.BackColor = System.Drawing.Color.White;
            txtStartDate.BackColor = System.Drawing.Color.Yellow;
            validatedState = false;
            Msg += "Please enter start date. ";
        }
        else if (strEndDate.Trim() == "")
        {
            txtStartDate.BackColor = System.Drawing.Color.White;
            txtEndDate.BackColor = System.Drawing.Color.Yellow;
            validatedState = false;
            Msg += "Please enter end date. ";
        }
        else
        {
            txtEndDate.BackColor = System.Drawing.Color.White;
            DateTime startDate = DateTime.Parse(strStartDate.Trim());
            DateTime endDate = DateTime.Parse(strEndDate.Trim());
            if (DateTime.Compare(startDate, endDate) > 0)
            {
                validatedState = false;
                txtStartDate.BackColor = System.Drawing.Color.Yellow;
                txtEndDate.BackColor = System.Drawing.Color.Yellow;
                Msg = Msg + "The end date must be a later date than the start date. ";
            }
            else
            {
                txtStartDate.BackColor = System.Drawing.Color.White;
                txtEndDate.BackColor = System.Drawing.Color.White;
            }

        }

        if (validatedState)
        {
            // fill session variables
            Session["txtFirstName"] = txtFirstName.Text;
            Session["txtLastName"] = txtLastName.Text;
            Session["txtPayRate"] = txtPayRate.Text;
            Session["txtStartDate"] = txtStartDate.Text;
            Session["txtEndDate"] = txtEndDate.Text;

            //Need to set session variables for all text boxes
            Response.Redirect("frmPersonnelVerified.aspx");
        }
        else
        {
            lblError.Text = Msg;
        }
    }
}